/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks;

import com.ordana.spelunkery.reg.ModBlocks;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WoodenRailBlock
extends BaseRailBlock {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;
    public static final int STABILITY_MAX_DISTANCE = 7;
    public static final IntegerProperty DISTANCE = BlockStateProperties.f_61388_;
    public static final BooleanProperty BOTTOM = BlockStateProperties.f_61427_;

    public WoodenRailBlock(boolean bl, BlockBehaviour.Properties properties) {
        super(bl, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(0)));
    }

    private static boolean isBottom(BlockGetter level, BlockPos pos) {
        return WoodenRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        Level level = context.m_43725_();
        int i = WoodenRailBlock.getDistance((BlockGetter)level, blockPos);
        Direction direction = context.m_8125_();
        boolean bl2 = direction == Direction.EAST || direction == Direction.WEST;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(this.m_7978_(), (Comparable)(bl2 ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH))).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(level.m_6425_(blockPos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(WoodenRailBlock.isBottom((BlockGetter)level, blockPos)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)f_152149_)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!level.m_5776_()) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = WoodenRailBlock.getDistance((BlockGetter)level, pos);
        BlockState blockState = (BlockState)((BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(WoodenRailBlock.isBottom((BlockGetter)level, pos)));
        if ((Integer)blockState.m_61143_((Property)DISTANCE) == 7 || WoodenRailBlock.shouldBeRemoved(pos, (Level)level, (RailShape)blockState.m_61143_(SHAPE))) {
            level.m_46961_(pos, true);
        } else if (state != blockState) {
            level.m_7731_(pos, blockState, 3);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return WoodenRailBlock.getDistance((BlockGetter)level, pos) < 7 || WoodenRailBlock.isBottom((BlockGetter)level, pos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_ && level.m_8055_(pos).m_60713_((Block)this)) {
            RailShape railShape = (RailShape)state.m_61143_(this.m_7978_());
            if (WoodenRailBlock.shouldBeRemoved(pos, level, railShape)) {
                WoodenRailBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
                level.m_7471_(pos, isMoving);
            } else {
                this.m_6360_(state, level, pos, block);
            }
        }
    }

    private static boolean shouldBeRemoved(BlockPos pos, Level level, RailShape railShape) {
        if (!WoodenRailBlock.isBottom((BlockGetter)level, pos)) {
            ArrayList<BlockState> neighbors = new ArrayList<BlockState>();
            int counter = 0;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState neighborState = level.m_8055_(pos.m_121945_(direction));
                if (!(neighborState.m_60734_() instanceof WoodenRailBlock)) continue;
                neighbors.add(neighborState);
            }
            for (BlockState state : neighbors) {
                RailShape neighborRailShape = (RailShape)state.m_61143_(SHAPE);
                if (railShape != neighborRailShape) continue;
                ++counter;
            }
            return counter == 0;
        }
        return !WoodenRailBlock.isBottom((BlockGetter)level, pos);
    }

    public static int getDistance(BlockGetter level, BlockPos pos) {
        Direction direction;
        BlockState blockState2;
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_().m_122173_(Direction.DOWN);
        int i = 7;
        if (WoodenRailBlock.isBottom(level, pos)) {
            return 0;
        }
        Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
        while (iterator.hasNext() && (!(blockState2 = level.m_8055_((BlockPos)mutableBlockPos.m_122159_((Vec3i)pos, direction = (Direction)iterator.next()))).m_60713_(ModBlocks.WOODEN_RAIL.get()) || (i = Math.min(i, (Integer)blockState2.m_61143_((Property)DISTANCE) + 1)) != 1)) {
        }
        return i;
    }

    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                switch ((RailShape)state.m_61143_(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)state.m_61143_(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)state.m_61143_(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        RailShape railShape = (RailShape)state.m_61143_(SHAPE);
        block0 : switch (mirror) {
            case LEFT_RIGHT: {
                switch (railShape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
                return super.m_6943_(state, mirror);
            }
            case FRONT_BACK: {
                switch (railShape) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.m_6943_(state, mirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, SHAPE, f_152149_, BOTTOM});
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0);
    }
}

